--MGC_LINE_FILENAME 0 maxplus2.hdl
-----------------------------------------------------------------------------
--                                                                         --
-- Copyright (c) 1994 by Altera Corp.  All rights reserved.                --
--                                                                         --
--                                                                         --
--  Description:  Package file for Altera macro functions and primitives   --
--                                                                         --
--                                                                         --
--                                                                         --
------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
library arithmetic;
use arithmetic.std_logic_arith.all;


package maxplus2 is
    component A_81MUX
        port (A, B, C, GN : in std_ulogic;
              D0, D1, D2, D3, D4, D5, D6, D7 : in std_ulogic;
              Y, WN : out std_ulogic);
    end component;

    component A_8COUNT
        port (A, B, C, D, E, F, G, H : in std_ulogic;
              LDN, GN, DNUP, SETN, CLRN, CLK: in std_ulogic;
              QA, QB, QC, QD, QE, QF, QG, QH, COUT : out std_ulogic);
    end component;

    component A_8FADD
        port (A8, A7, A6, A5, A4, A3, A2, A1 : in std_ulogic;
              B8, B7, B6, B5, B4, B3, B2, B1 : in std_ulogic;
              CIN : in std_ulogic;
              SUM8, SUM7, SUM6, SUM5, SUM4, SUM3, SUM2, SUM1, COUT : out std_ulogic);

    end component;

    component A_8MCOMP
        port (A7, A6, A5, A4, A3, A2, A1, A0 : in std_ulogic;
              B7, B6, B5, B4, B3, B2, B1, B0 : in std_ulogic;
              ALTB, AEQB, AGTB : out std_ulogic;
              AEB7, AEB6, AEB5, AEB4, AEB3, AEB2, AEB1, AEB0 : out std_ulogic);
    end component;

    component CARRY
        port (A_IN  : in std_ulogic;
              A_OUT : out std_ulogic);
    end component;

    component CASCADE
        port (A_IN  : in std_ulogic;
              A_OUT : out std_ulogic);
    end component;

    component LCELL
        port (A_IN  : in std_ulogic;
              A_OUT : out std_ulogic);
    end component;

    component MCELL
        port (A_IN  : in std_ulogic;
              A_OUT : out std_ulogic);
    end component;

    component SOFT
        port (A_IN  : in std_ulogic;
              A_OUT : out std_ulogic);
    end component;

    component GLOBAL
        port (A_IN  : in std_ulogic;
              A_OUT : out std_ulogic);
    end component;

    component SCLK
        port (A_IN  : in std_ulogic;
              A_OUT : out std_ulogic);
    end component;

    component EXP
        port (A_IN  : in std_ulogic;
              A_OUT : out std_ulogic);
    end component;

    component OPNDRN
        port (IN1  : in std_ulogic;
              Y : out std_ulogic);
    end component;

end maxplus2;